export interface Coordinates {
  type: 'Point';
  coordinates: [number, number]; // [longitude, latitude]
}

export interface UserLocation {
  country: string;
  coordinates: Coordinates;
  isDefault: boolean;
  lastUpdated: Date | string;
}

export interface User {
  _id: string;
  name: string;
  email: string;
  phone: string;
  password?: string;
  role: 'superadmin' | 'store_manager' | 'delivery_boy' | 'customer' | 'admin';
  status: boolean;
  avatar: {
    public_id: string;
    url: string;
  };
  location: UserLocation;
  emailVerified: boolean;
  phoneVerified: boolean;
  addresses: any[]; // Consider defining a proper Address interface
  deliveryBoy: string | null;
  storeManager?: string; // For store manager users
  storeId?: string; // For store managers - legacy field, consider using storeManager instead
  loginAttempts: number;
  createdAt: Date | string;
  updatedAt: Date | string;
  __v?: number;
}

export interface StoreManager extends Omit<User, 'storeManager'> {
  role: 'store_manager';
  storeManager: string; // Store ID this manager is associated with
}

export interface Order {
  id: string;
  customerId: string;
  customerName: string;
  total: number;
  status: 'pending' | 'confirmed' | 'packed' | 'out_for_delivery' | 'delivered' | 'cancelled' | 'returned';
  items: OrderItem[];
  deliveryAddress: string;
  paymentMethod: 'cod' | 'online';
  createdAt: string;
  deliveryBoyId?: string;
  storeId: string;
}

export interface OrderItem {
  id: string;
  productId: string;
  name: string;
  price: number;
  quantity: number;
  image: string;
}

export interface Product {
  id: string;
  name: string;
  description: string;
  price: number;
  image: string;
  category: string;
  brand: string;
  unit: string;
  stock: number;
  storeId: string;
  prescription_required: boolean;
}

export interface Store {
  id: string;
  name: string;
  address: string;
  phone: string;
  email: string;
  managerId: string;
  isActive: boolean;
}

export interface DeliveryBoy {
  id: string;
  name: string;
  phone: string;
  email: string;
  isActive: boolean;
  earnings: number;
  deliveredOrders: number;
}