import React, { useState, useEffect } from 'react';
import { AlertTriangle, Clock, Mail, Phone, Home } from 'lucide-react';
import { Link } from 'react-router-dom';
import { useWebSettings } from '../../../context/WebSettingsContext';

const Maintenance = () => {
  const { settings } = useWebSettings();
  const [countdown, setCountdown] = useState(300); // 5 minutes in seconds

  useEffect(() => {
    const timer = setInterval(() => {
      setCountdown((prev) => (prev > 0 ? prev - 1 : 0));
    }, 1000);

    return () => clearInterval(timer);
  }, []);

  const formatTime = (seconds: number) => {
    const mins = Math.floor(seconds / 60);
    const secs = seconds % 60;
    return `${mins.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
  };

  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 flex flex-col items-center justify-center p-4">
      <div className="bg-white p-8 rounded-xl shadow-xl max-w-2xl w-full text-center border border-gray-200">
        <div className="flex justify-center mb-6">
          <div className="p-4 bg-yellow-50 rounded-full">
            <AlertTriangle className="h-16 w-16 text-yellow-500" />
          </div>
        </div>
        
        <h1 className="text-4xl font-bold text-gray-800 mb-3">
          We'll Be Back Soon!
        </h1>
        
        <p className="text-gray-600 mb-2">
          {settings?.siteName || 'Our website'} is currently undergoing scheduled maintenance.
        </p>
        
        <p className="text-gray-500 mb-6">
          We apologize for the inconvenience. We're working hard to improve your experience.
        </p>

        <div className="bg-blue-50 border-l-4 border-blue-500 p-4 mb-6 text-left">
          <div className="flex items-center text-blue-700">
            <Clock className="h-5 w-5 mr-2" />
            <span>Estimated time until completion: {formatTime(countdown)}</span>
          </div>
        </div>

        <div className="mt-8 pt-6 border-t border-gray-200">
          <h3 className="text-lg font-medium text-gray-800 mb-4">Need Help?</h3>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4 text-left">
            {settings?.siteEmail && (
              <div className="flex items-center text-gray-600">
                <Mail className="h-5 w-5 mr-2 text-gray-400" />
                <a href={`mailto:${settings.siteEmail}`} className="hover:text-blue-600">
                  {settings.siteEmail}
                </a>
              </div>
            )}
            {settings?.sitePhone && (
              <div className="flex items-center text-gray-600">
                <Phone className="h-5 w-5 mr-2 text-gray-400" />
                <a href={`tel:${settings.sitePhone.replace(/\D/g, '')}`} className="hover:text-blue-600">
                  {settings.sitePhone}
                </a>
              </div>
            )}
            {settings?.siteAddress && (
              <div className="flex items-start text-gray-600 md:col-span-2">
                <Home className="h-5 w-5 mr-2 mt-0.5 text-gray-400 flex-shrink-0" />
                <span>{settings.siteAddress}</span>
              </div>
            )}
          </div>
        </div>

        <div className="mt-8 pt-6 border-t border-gray-200">
          <p className="text-sm text-gray-500">
            &copy; {new Date().getFullYear()} {settings?.siteName || 'Our Website'}. All rights reserved.
          </p>
        </div>
      </div>
    </div>
  );
};

export default Maintenance;
