import React, { useState, useEffect } from 'react';
import { useNavigate, useLocation, Outlet } from 'react-router-dom';
import Layout from '@/components/shared/Layout';
import Sidebar from '@/components/shared/Sidebar';
import { adminSidebarItems } from '../AdminLayout';
import { Image as ImageIcon, LayoutGrid } from 'lucide-react';

const HomepageSections: React.FC = () => {
  const navigate = useNavigate();
  const location = useLocation();
  const [activeTab, setActiveTab] = useState('banners');

  const tabs = [
    { id: 'banners', name: 'Banners', icon: ImageIcon },
    { id: 'sections', name: 'Product Sections', icon: LayoutGrid },
  ];

  const navigateTo = (path: string) => {
    navigate(`/admin/homepage/${path}`);
  };

  // Set active tab based on current route
  useEffect(() => {
    const path = location.pathname;
    if (path.includes('banners')) {
      setActiveTab('banners');
    } else if (path.includes('sections')) {
      setActiveTab('sections');
    }
  }, [location.pathname]);

  return (
    <Layout title="Homepage Management" sidebar={<Sidebar items={adminSidebarItems} />}>
      <div className="space-y-6">
        <div className="flex justify-between items-center">
          <h1 className="text-2xl font-bold">Homepage Management</h1>
        </div>

        <div className="border-b border-gray-200">
          <nav className="-mb-px flex space-x-8">
            {tabs.map((tab) => (
              <button
                key={tab.id}
                onClick={() => navigateTo(tab.id)}
                className={`whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm ${
                  activeTab === tab.id
                    ? 'border-blue-500 text-blue-600'
                    : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'
                }`}
              >
                <div className="flex items-center">
                  <tab.icon className="mr-2 h-4 w-4" />
                  {tab.name}
                </div>
              </button>
            ))}
          </nav>
        </div>

        <div className="p-6">
          <div className="bg-white rounded-lg shadow p-6">
            <div className="space-y-6">
              <Outlet />
            </div>
          </div>
        </div>
      </div>
    </Layout>
  );
};

export default HomepageSections;