import { LayoutDashboard, ShoppingCart, Package, Truck, Users, Store, BarChart3, Settings, Tag, Grid3X3, Calculator, Percent, Building, Pill as Pills, Gift, DollarSign, CreditCard, TrendingUp, RefreshCw, Layout, Image, Percent as PercentIcon, Mail } from 'lucide-react';
import { SidebarItem } from '../../components/shared/Sidebar';

export const adminSidebarItems: SidebarItem[] = [
  {
    name: 'Dashboard',
    href: '/admin',
    icon: LayoutDashboard
  },
  {
    name: 'Orders',
    href: '/admin/orders',
    icon: ShoppingCart,
    children: [
      { name: 'Order Tracking', href: '/admin/orders/tracking', icon: Truck },
      { name: 'Returns & Refunds', href: '/admin/orders/returns', icon: BarChart3 },
      { name: 'Invoices', href: '/admin/orders/invoices', icon: CreditCard }
    ]
  },
  {
    name: 'Products',
    href: '/admin/products',
    icon: Package,
    children: [
      { name: 'Brands', href: '/admin/products/brands', icon: Tag },
      { name: 'Categories', href: '/admin/products/categories', icon: Grid3X3 },
      { name: 'Units', href: '/admin/products/units', icon: Calculator },
      { name: 'Taxes', href: '/admin/products/taxes', icon: Percent },
      { name: 'Discounts', href: '/admin/products/discounts', icon: PercentIcon },
      { name: 'Stores', href: '/admin/store-managers', icon: Building },
      { name: 'Items', href: '/admin/products/items', icon: Pills },
      { name: 'Bulk Operations', href: '/admin/products/bulk-operations', icon: RefreshCw }
    ]
  },
  {
    name: 'Store Managers',
    href: '/admin/store-managers',
    icon: Store,
    children: [
      { name: 'Manage Stores', href: '/admin/store-managers', icon: Store },
      { name: 'Add Store Manager', href: '/admin/store-managers/create', icon: Users }
    ]
  },
  {
    name: 'Delivery',
    href: '/admin/delivery',
    icon: Truck,
    children: [
      { name: 'Delivery Boys', href: '/admin/delivery/boys', icon: Users },
      { name: 'Funds Transfer', href: '/admin/delivery/funds', icon: DollarSign },
      { name: 'Cash Collections', href: '/admin/delivery/collections', icon: CreditCard },
      { name: 'Bonuses', href: '/admin/bonuses', icon: Gift }
    ]
  },
  {
    name: 'Customers',
    href: '/admin/customers',
    icon: Users
  },
  {
    name: 'Coupons',
    href: '/admin/coupons',
    icon: Tag,
  },
  {
    name: 'Reports',
    href: '/admin/reports',
    icon: BarChart3,
    children: [
      { name: 'Sales Reports', href: '/admin/reports/sales', icon: TrendingUp },
      { name: 'Delivery Performance', href: '/admin/reports/delivery', icon: Truck },
      { name: 'Tax Reports', href: '/admin/reports/tax', icon: Percent },
      { name: 'Inventory Reports', href: '/admin/reports/inventory', icon: Package },
      { name: 'Commission Reports', href: '/admin/reports/commission', icon: DollarSign }
    ]
  },
  {
    name: 'Homepage',
    href: '/admin/homepage',
    icon: Layout,
    children: [
      { name: 'Banners', href: '/admin/homepage/banners', icon: Image as any },
      { name: 'Product Sections', href: '/admin/homepage/sections', icon: Layout }
    ]
  },
  {
    name: 'Web Settings',
    href: '/admin/web-settings',
    icon: Settings,
    children: [
      { name: 'General', href: '/admin/web-settings/general', icon: Settings },
      { name: 'Appearance', href: '/admin/web-settings/appearance', icon: Layout },
      { name: 'SEO', href: '/admin/web-settings/seo', icon: BarChart3 },
      { name: 'Social Media', href: '/admin/web-settings/social', icon: Users },
      { name: 'Payment Methods', href: '/admin/web-settings/payments', icon: CreditCard },
      { name: 'Email Templates', href: '/admin/web-settings/email-templates', icon: Mail as any }
    ]
  },
  {
    name: 'Settings',
    href: '/admin/settings',
    icon: Settings
  }
];