import {
  LayoutDashboard,
  ClipboardList,
  Pill,
  User,
  FileText,
  Calendar,
  MessageSquare,
  Settings,
  Clock
} from 'lucide-react';
import { SidebarItem } from '../../components/shared/Sidebar';

export const pharmacistSidebarItems: SidebarItem[] = [
  {
    name: 'Dashboard',
    href: '/pharmacist',
    icon: LayoutDashboard
  },
  {
    name: 'Prescriptions',
    href: '/pharmacist/prescriptions',
    icon: ClipboardList
  },
  {
    name: 'Medications',
    href: '/pharmacist/medications',
    icon: Pill,
    children: [
      { name: 'Verify Medications', href: '/pharmacist/medications/verify', icon: Pill },
      { name: 'Drug Interactions', href: '/pharmacist/medications/interactions', icon: FileText }
    ]
  },
  {
    name: 'Schedule',
    href: '/pharmacist/schedule',
    icon: Calendar
  },
  {
    name: 'Patient Consultations',
    href: '/pharmacist/consultations',
    icon: MessageSquare
  },
  {
    name: 'Work History',
    href: '/pharmacist/history',
    icon: Clock
  },
  {
    name: 'Profile',
    href: '/pharmacist/profile',
    icon: User
  },
  {
    name: 'Settings',
    href: '/pharmacist/settings',
    icon: Settings
  }
];