/**
 * Helper function to construct proper image URLs
 * Handles different types of image paths and ensures proper URL formatting
 */

export const getImageUrl = (path: string): string => {
  if (!path) return '';
  
  // If it's already a full URL, return as is
  if (path.startsWith('http')) return path;
  
  // Get base URL from environment or use default
  const baseUrl = import.meta.env.VITE_API_BASE_URL || 'http://localhost:5000';
  
  // Remove any leading slashes to prevent double slashes
  const cleanPath = path.replace(/^\/+/, '');
  
  // Encode the path components to handle special characters
  const encodedPath = cleanPath
    .split('/')
    .map(segment => encodeURIComponent(segment))
    .join('/');
  
  // Handle different path patterns
  if (cleanPath.startsWith('uploads/') || cleanPath.startsWith('prescriptions/')) {
    return `${baseUrl}/${encodedPath}`;
  }
  
  // For files in the uploads directory
  if (cleanPath.includes('rx-')) {
    return `${baseUrl}/uploads/prescriptions/${encodedPath}`;
  }
  
  // Default case - return the path with base URL and proper encoding
  return `${baseUrl}/uploads/${encodedPath}`;
};
