export interface Banner {
  _id: string;
  title: string;
  subtitle?: string;
  image: string;
  link?: string;
  isActive: boolean;
  position: number;
  type: 'main' | 'secondary' | 'promo';
  startDate: string;
  endDate?: string;
  createdAt: string;
  updatedAt: string;
}

export interface BannerCreateDTO {
  title: string;
  subtitle?: string;
  image: string;
  link?: string;
  isActive?: boolean;
  position?: number;
  type?: 'main' | 'secondary' | 'promo';
  startDate?: string;
  endDate?: string;
}

export interface BannerUpdateDTO extends Partial<BannerCreateDTO> {}

export interface BannerListResponse {
  success: boolean;
  count: number;
  data: Banner[];
}

export interface BannerResponse {
  success: boolean;
  data: Banner;
}
