import axios from 'axios';

const API_URL = import.meta.env.VITE_API_URL || 'http://localhost:5000/api';

export interface Product {
  id: string;
  name: string;
  description: string;
  price: number;
  originalPrice?: number;
  image?: string;
  images?: string[];
  inStock: boolean;
  category?: string;
  brand?: string;
  rating?: number;
  reviews?: number;
  highlights?: string[];
  specifications?: { name: string; value: string }[];
}

export const getProductById = async (id: string): Promise<Product> => {
  try {
    const response = await axios.get(`${API_URL}/items/${id}`);
    return response.data.data;
  } catch (error) {
    console.error('Error fetching product:', error);
    throw error;
  }
};

export const getProducts = async (params?: {
  category?: string;
  search?: string;
  page?: number;
  limit?: number;
}): Promise<{ data: Product[]; total: number }> => {
  try {
    const response = await axios.get(`${API_URL}/items`, { params });
    return response.data;
  } catch (error) {
    console.error('Error fetching products:', error);
    throw error;
  }
};
