import api from './api';

interface LocationCoords {
  lat: number;
  lng: number;
}

interface Store {
  _id: string;
  store: {
    storeName: string;
    location: {
      coordinates: [number, number];
    };
  };
  distance: number;
  distanceKm: number;
}

export const locationService = {
  // Get nearby stores
  getNearbyStores: async (coords: LocationCoords, maxDistance = 3000) => {
    try {
      const response = await api.get('/location/nearby-stores', {
        params: {
          lat: coords.lat,
          lng: coords.lng,
          maxDistance
        }
      });
      return response.data.data as Store[];
    } catch (error) {
      console.error('Failed to fetch nearby stores:', error);
      throw error;
    }
  },

  // Reverse geocode coordinates to address
  reverseGeocode: async (coords: LocationCoords) => {
    try {
      const response = await api.get('/location/geocode', {
        params: {
          lat: coords.lat,
          lng: coords.lng
        }
      });
      return response.data.data;
    } catch (error) {
      console.error('Reverse geocoding failed:', error);
      throw error;
    }
  },

  // Save user location
  saveUserLocation: async (location: any) => {
    try {
      const response = await api.put('/location', location);
      return response.data;
    } catch (error) {
      console.error('Failed to save location:', error);
      throw error;
    }
  }
};

export default locationService;
