import {
  LayoutDashboard,
  ShoppingCart,
  Package,
  Truck,
  BarChart3,
  User,
  ClipboardList,
  Pill,
  Package2,
  ClipboardCheck,
  Clock,
  CheckCircle
} from 'lucide-react';
import { SidebarItem } from '../../components/shared/Sidebar';

export const storeSidebarItems: SidebarItem[] = [
  {
    name: 'Dashboard',
    href: '/store',
    icon: LayoutDashboard
  },
  {
    name: 'Orders',
    href: '/store/orders',
    icon: ShoppingCart
  },
  {
    name: 'Products',
    href: '/store/products',
    icon: Package,
   
  },
  {
    name: 'Inventory',
    href: '/store/inventory',
    icon: Package2,
  },
  {
    name: 'Pharmacist',
    href: '/store/pharmacist',
    icon: Pill,
    children: [
      { name: 'Prescriptions', href: '/store/pharmacist/prescriptions', icon: ClipboardList }
    ]
  },
  {
    name: 'Picker/Packer',
    href: '/store/picker-packer',
    icon: ClipboardCheck,
    children: [
      { name: 'Orders to Pick', href: '/store/picker-packer/to-pick', icon: Package },
      { name: 'In Progress', href: '/store/picker-packer/in-progress', icon: Clock },
      { name: 'Ready for Dispatch', href: '/store/picker-packer/ready', icon: CheckCircle }
    ]
  },
  {
    name: 'Delivery',
    href: '/store/delivery',
    icon: Truck
  },
  {
    name: 'Reports',
    href: '/store/reports',
    icon: BarChart3
  },
  {
    name: 'Profile',
    href: '/store/profile',
    icon: User
  }
];