import React from 'react';
import Layout from '@/components/shared/Layout';
import Sidebar from '@/components/shared/Sidebar';
import { adminSidebarItems } from '../AdminLayout';

const SEOSettings: React.FC = () => {
  return (
    <Layout title="SEO Settings" sidebar={<Sidebar items={adminSidebarItems} />}>
      <div className="space-y-6 max-w-4xl mx-auto pb-12">
        <div className="bg-white p-8 rounded-lg shadow">
          <h1 className="text-xl font-semibold mb-4">SEO Settings</h1>
          <p>Configure site meta tags, search engine settings, sitemap, and robots.txt rules here.</p>
          {/* SEO fields and configuration forms will go here */}
          <div className="mt-6 text-gray-500">SEO management features are coming soon.</div>
        </div>
      </div>
    </Layout>
  );
};

export default SEOSettings;
