import { Routes, Route, Navigate } from 'react-router-dom';
import WebSettings from './WebSettings';
import AppearanceSettings from './appearance';
import SEOSettings from './seo';
import SocialSettings from './social';
import PaymentSettings from './payments';
import EmailTemplatesSettings from './email-templates';

const WebSettingsRoutes = () => {
  return (
    <Routes>
      <Route index element={<Navigate to="general" replace />} />
      <Route path=":tab" element={<WebSettings />} />
      <Route path="appearance" element={<AppearanceSettings />} />
      <Route path="seo" element={<SEOSettings />} />
      <Route path="social" element={<SocialSettings />} />
      <Route path="payments" element={<PaymentSettings />} />
      <Route path="email-templates" element={<EmailTemplatesSettings />} />
    </Routes>
  );
};

export default WebSettingsRoutes;
