import React from 'react';
import Layout from '@/components/shared/Layout';
import Sidebar from '@/components/shared/Sidebar';
import { adminSidebarItems } from '../AdminLayout';

const EmailTemplatesSettings: React.FC = () => {
  return (
    <Layout title="Email Templates" sidebar={<Sidebar items={adminSidebarItems} />}>
      <div className="space-y-6 max-w-4xl mx-auto pb-12">
        <div className="bg-white p-8 rounded-lg shadow">
          <h1 className="text-xl font-semibold mb-4">Email Templates</h1>
          <p>Customize the email notifications and templates sent from your site.</p>
          {/* Email template forms and preview/editors will go here */}
          <div className="mt-6 text-gray-500">Email template customization coming soon.</div>
        </div>
      </div>
    </Layout>
  );
};

export default EmailTemplatesSettings;
