import { useState, useEffect } from 'react';
import api from '@/services/api';

export default function useWebSettings() {
  const [settings, setSettings] = useState({
    siteStoreLogo: '',
    siteStoreName: 'Healthsta',
    siteStoreTagline: 'Pharmacy'
  });
  const [isLoading, setIsLoading] = useState(true);
  const [error, setError] = useState<Error | null>(null);

  useEffect(() => {
    const fetchSettings = async () => {
      try {
        const response = await api.get('/web-settings');
        if (response.data.success) {
          setSettings(prev => ({
            siteStoreLogo: response.data.data.siteStoreLogo || prev.siteStoreLogo,
            siteStoreName: response.data.data.siteStoreName || prev.siteStoreName,
            siteStoreTagline: response.data.data.siteStoreTagline || prev.siteStoreTagline
          }));
        }
      } catch (err) {
        console.error('Failed to load web settings:', err);
        setError(err instanceof Error ? err : new Error('Failed to load settings'));
      } finally {
        setIsLoading(false);
      }
    };

    fetchSettings();
  }, []);

  return { settings, isLoading, error };
}
