import React from 'react';
import { useAuth } from '../../context/AuthContext';
import { LogOut, Bell } from 'lucide-react';

interface LayoutProps {
  children: React.ReactNode;
  title: string;
  sidebar?: React.ReactNode;
}

const Layout: React.FC<LayoutProps> = ({ children, title, sidebar }) => {
  const { user, logout } = useAuth();

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Header */}
      <header className="bg-white shadow-sm border-b">
        <div className="px-4 sm:px-6 lg:px-8">
          <div className="flex justify-between items-center h-16">
            <div className="flex items-center">
              <div className="flex-shrink-0">
                <h1 className="text-2xl font-bold text-blue-600">MedStore</h1>
              </div>
              <div className="hidden md:block ml-8">
                <h2 className="text-lg font-medium text-gray-900">{title}</h2>
              </div>
            </div>

            <div className="flex items-center space-x-4">
              <button className="p-2 text-gray-400 hover:text-gray-600 transition-colors">
                <Bell className="w-5 h-5" />
              </button>
              
              <div className="flex items-center space-x-3">
                <div className="flex items-center space-x-2">
                  <img
                    src={user?.avatar || 'https://images.pexels.com/photos/2379005/pexels-photo-2379005.jpeg?auto=compress&cs=tinysrgb&w=150&h=150&dpr=1'}
                    alt={user?.name}
                    className="w-8 h-8 rounded-full object-cover"
                  />
                  <div className="hidden md:block">
                    <p className="text-sm font-medium text-gray-900">{user?.name || 'User'}</p>
                    <p className="text-xs text-gray-500 capitalize">
                      {user?.role?.name ? user.role.name.replace(/_/g, ' ') : 'user'}
                    </p>
                  </div>
                </div>
                <button
                  onClick={logout}
                  className="p-2 text-gray-400 hover:text-gray-600 transition-colors"
                  title="Logout"
                >
                  <LogOut className="w-5 h-5" />
                </button>
              </div>
            </div>
          </div>
        </div>
      </header>

      <div className="flex">
        {/* Sidebar */}
        {sidebar && (
          <div className="hidden md:flex md:w-64 md:flex-col">
            <div className="flex flex-col flex-1 min-h-0 bg-white shadow-sm">
              {sidebar}
            </div>
          </div>
        )}

        {/* Main content */}
        <div className={`flex-1 ${sidebar ? 'md:ml-0' : ''}`}>
          <main className="flex-1">
            <div className="py-6">
              <div className="px-4 sm:px-6 md:px-8">
                <div className="md:hidden mb-4">
                  <h2 className="text-lg font-medium text-gray-900">{title}</h2>
                </div>
                {children}
              </div>
            </div>
          </main>
        </div>
      </div>
    </div>
  );
};
export default Layout;
