import { CheckCircle, Clock, Star, Phone } from 'lucide-react';

const features = [
  {
    icon: CheckCircle,
    title: 'Licensed Pharmacy',
    description: 'Trusted by millions for reliable healthcare services',
    color: 'text-green-600',
    bgColor: 'bg-green-50',
  },
  {
    icon: Clock,
    title: 'Express Delivery',
    description: 'Fast and secure delivery to your doorstep',
    color: 'text-blue-600',
    bgColor: 'bg-blue-50',
  },
  {
    icon: Star,
    title: 'Expert Care',
    description: 'Professional consultation available 24/7',
    color: 'text-purple-600',
    bgColor: 'bg-purple-50',
  },
  {
    icon: Phone,
    title: 'Customer Support',
    description: 'Dedicated support team always ready to help',
    color: 'text-orange-600',
    bgColor: 'bg-orange-50',
  },
];

export default function WhyChoose() {
  return (
    <section className="py-8 sm:py-12 lg:py-16 bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-8 sm:mb-12">
          <h2 className="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900 mb-2 sm:mb-4">Why Choose Healthsta?</h2>
          <p className="text-sm sm:text-base text-gray-600">Trusted by millions for reliable healthcare services</p>
        </div>

        <div className="grid grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6 lg:gap-8">
          {features.map((feature) => {
            const Icon = feature.icon;
            return (
              <div key={feature.title} className="text-center">
                <div className={`w-12 h-12 sm:w-14 sm:h-14 lg:w-16 lg:h-16 ${feature.bgColor} rounded-full flex items-center justify-center mx-auto mb-3 sm:mb-4`}>
                  <Icon className={`w-6 h-6 sm:w-7 sm:h-7 lg:w-8 lg:h-8 ${feature.color}`} />
                </div>
                <h3 className="font-bold text-gray-900 mb-1 sm:mb-2 text-sm sm:text-base">{feature.title}</h3>
                <p className="text-xs sm:text-sm text-gray-600">{feature.description}</p>
              </div>
            );
          })}
        </div>
      </div>
    </section>
  );
}
