import React, { useState } from 'react';
import Header from './Header';
import Footer from './Footer';

const PaymentPage: React.FC = () => {
  const [paymentMethod, setPaymentMethod] = useState<'upi' | 'card' | 'delivery'>('delivery');
  const [upiId, setUpiId] = useState('');
  const [cardDetails, setCardDetails] = useState({
    cardNumber: '',
    cardHolderName: '',
    expiry: '',
    cvv: ''
  });

  const totalCharges = 177;

  const handlePaymentMethodChange = (method: 'upi' | 'card' | 'delivery') => {
    setPaymentMethod(method);
  };

  const renderPaymentSection = () => {
    switch (paymentMethod) {
      case 'upi':
        return (
          <div className="payment-upi-section">
            <div className="flex items-center justify-between mb-4">
              <span>Scan & Pay</span>
              <button className="text-blue-600">Show QR code</button>
            </div>
            <div className="mb-4">
              <label className="block mb-2">Enter your UPI ID</label>
              <input 
                type="text" 
                value={upiId}
                onChange={(e) => setUpiId(e.target.value)}
                placeholder="username@bank"
                className="w-full p-2 border rounded"
              />
              <div className="flex items-center mt-2">
                <input 
                  type="checkbox" 
                  id="save-upi"
                  className="mr-2"
                />
                <label htmlFor="save-upi">Save this ID for faster checkout</label>
              </div>
            </div>
            <button className="w-full bg-blue-600 text-white p-2 rounded">
              Verify & Pay
            </button>
          </div>
        );
      case 'card':
        return (
          <div className="payment-card-section">
            <div className="mb-4">
              <label className="block mb-2">Enter Card Number</label>
              <input 
                type="text" 
                value={cardDetails.cardNumber}
                onChange={(e) => setCardDetails({...cardDetails, cardNumber: e.target.value})}
                placeholder="Card Number"
                className="w-full p-2 border rounded"
              />
            </div>
            <div className="mb-4">
              <label className="block mb-2">Enter Card Holder's Name</label>
              <input 
                type="text" 
                value={cardDetails.cardHolderName}
                onChange={(e) => setCardDetails({...cardDetails, cardHolderName: e.target.value})}
                placeholder="Name on card"
                className="w-full p-2 border rounded"
              />
            </div>
            <div className="flex space-x-4 mb-4">
              <div className="w-1/2">
                <label className="block mb-2">Enter Expiry</label>
                <input 
                  type="text" 
                  value={cardDetails.expiry}
                  onChange={(e) => setCardDetails({...cardDetails, expiry: e.target.value})}
                  placeholder="MM/YY"
                  className="w-full p-2 border rounded"
                />
              </div>
              <div className="w-1/2">
                <label className="block mb-2">Enter CVV</label>
                <input 
                  type="text" 
                  value={cardDetails.cvv}
                  onChange={(e) => setCardDetails({...cardDetails, cvv: e.target.value})}
                  placeholder="***"
                  className="w-full p-2 border rounded"
                />
              </div>
            </div>
            <div className="flex items-center mb-4">
              <input 
                type="checkbox" 
                id="save-card"
                className="mr-2"
              />
              <label htmlFor="save-card">Save this ID for faster checkout</label>
            </div>
            <button className="w-full bg-blue-600 text-white p-2 rounded">
              Pay Now
            </button>
          </div>
        );
      case 'delivery':
      default:
        return (
          <div className="payment-delivery-section">
            <div className="bg-blue-100 p-4 rounded mb-4">
              <div className="flex items-start">
                <svg className="w-6 h-6 text-blue-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                  <path fillRule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clipRule="evenodd" />
                </svg>
                <p className="text-sm">
                  You will need to pay a total of ₹186, which includes a ₹9 cash handling fee.
                  You can avoid this fee by paying online.
                </p>
              </div>
            </div>
            <button className="w-full bg-blue-600 text-white p-2 rounded">
              Place Order
            </button>
          </div>
        );
    }
  };

  return (
    <div className="payment-page">
      <Header />
      <div className="container mx-auto px-4 py-8">
        <div className="max-w-md mx-auto">
          <h1 className="text-2xl font-bold mb-6">Payment</h1>
          
          {/* Payment Method Selection */}
          <div className="payment-methods mb-6">
            <div className="flex space-x-4 mb-4">
              <button 
                className={`flex-1 p-2 rounded ${paymentMethod === 'upi' ? 'bg-blue-600 text-white' : 'bg-gray-200'}`}
                onClick={() => handlePaymentMethodChange('upi')}
              >
                UPI
              </button>
              <button 
                className={`flex-1 p-2 rounded ${paymentMethod === 'card' ? 'bg-blue-600 text-white' : 'bg-gray-200'}`}
                onClick={() => handlePaymentMethodChange('card')}
              >
                Debit/Credit cards
              </button>
              <button 
                className={`flex-1 p-2 rounded ${paymentMethod === 'delivery' ? 'bg-blue-600 text-white' : 'bg-gray-200'}`}
                onClick={() => handlePaymentMethodChange('delivery')}
              >
                Pay on Delivery
              </button>
            </div>
          </div>

          {/* Payment Section */}
          {renderPaymentSection()}

          {/* Total Charges */}
          <div className="total-charges mt-6 text-right">
            <span className="text-xl font-bold">Total Charges: ₹{totalCharges}</span>
          </div>
        </div>
      </div>
      <Footer />
    </div>
  );
};

export default PaymentPage;



