import { Phone, Mail, CheckCircle } from 'lucide-react';
import useWebSettings from '../../hooks/useWebSettings';

export default function Footer() {
  const { settings } = useWebSettings();
  
  // Get the logo URL or fallback to default
  const logoUrl = settings.siteStoreLogo || '';
  const siteName = settings.siteStoreName || 'Helthsta';
  const siteTagline = settings.siteStoreTagline || 'Pharmacy';
  const siteEmail = settings.siteStoreEmail || 'care@helthsta.com';
  const sitePhone = settings.siteStorePhone || '1-800-123-4567';
  const siteDescription = settings.siteStoreDescription || "India's most trusted pharmacy chain. Get authentic medicines, and healthcare products delivered safely to your doorstep.";
  return (
    <footer className="bg-gray-50 pt-8 sm:pt-12 lg:pt-16 pb-6 sm:pb-8">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8 sm:gap-10 lg:gap-12 mb-8 sm:mb-12">
          <div>
            <div className="mb-4 sm:mb-6">
              {logoUrl ? (
                <img 
                  src={logoUrl} 
                  alt={siteName}
                  className="h-16 w-auto sm:h-20 object-contain"
                  onError={(e) => {
                    // Fallback to text if image fails to load
                    const target = e.target as HTMLImageElement;
                    target.style.display = 'none';
                    const fallback = document.createElement('div');
                    fallback.className = 'w-16 h-16 sm:w-20 sm:h-20 bg-blue-700 rounded-full flex items-center justify-center flex-shrink-0';
                    fallback.innerHTML = `<span class="text-white font-bold text-2xl sm:text-3xl">${siteName.charAt(0)}</span>`;
                    target.parentNode?.insertBefore(fallback, target.nextSibling);
                  }}
                />
              ) : (
                <div className="w-16 h-16 sm:w-20 sm:h-20 bg-blue-700 rounded-full flex items-center justify-center flex-shrink-0">
                  <span className="text-white font-bold text-2xl sm:text-3xl">{siteName.charAt(0)}</span>
                </div>
              )}
            </div>
            <p className="text-sm sm:text-base text-gray-600 mb-4 sm:mb-6">
              {siteDescription}
            </p>
            <div className="space-y-2 sm:space-y-3">
              <div className="flex items-center space-x-2 sm:space-x-3 text-gray-600">
                <Phone className="w-3 h-3 sm:w-4 sm:h-4 flex-shrink-0" />
                <span className="text-xs sm:text-sm">{sitePhone}</span>
              </div>
              <div className="flex items-center space-x-2 sm:space-x-3 text-gray-600">
                <Mail className="w-3 h-3 sm:w-4 sm:h-4 flex-shrink-0" />
                <span className="text-xs sm:text-sm">{siteEmail}</span>
              </div>
            </div>
          </div>

          <div>
            <h4 className="font-bold text-gray-900 mb-3 sm:mb-4 text-sm sm:text-base">Services</h4>
            <ul className="space-y-2 sm:space-y-3">
              <li>
                <a href="#" className="text-sm sm:text-base text-gray-600 hover:text-blue-700">
                  Order Medicines
                </a>
              </li>
              <li>
                <a href="#" className="text-sm sm:text-base text-gray-600 hover:text-blue-700">
                  Upload Prescription
                </a>
              </li>
              <li>
                <a href="#" className="text-sm sm:text-base text-gray-600 hover:text-blue-700">
                  Doctor Consultations
                </a>
              </li>
              <li>
                <a href="#" className="text-sm sm:text-base text-gray-600 hover:text-blue-700">
                  Health Checkups
                </a>
              </li>
            </ul>
          </div>

          <div>
            <h4 className="font-bold text-gray-900 mb-3 sm:mb-4 text-sm sm:text-base">Support</h4>
            <ul className="space-y-2 sm:space-y-3">
              <li>
                <a href="#" className="text-sm sm:text-base text-gray-600 hover:text-blue-700">
                  Help Center
                </a>
              </li>
              <li>
                <a href="#" className="text-sm sm:text-base text-gray-600 hover:text-blue-700">
                  Track Order
                </a>
              </li>
              <li>
                <a href="#" className="text-sm sm:text-base text-gray-600 hover:text-blue-700">
                  Return Policy
                </a>
              </li>
              <li>
                <a href="#" className="text-sm sm:text-base text-gray-600 hover:text-blue-700">
                  Privacy Policy
                </a>
              </li>
              <li>
                <a href="#" className="text-sm sm:text-base text-gray-600 hover:text-blue-700">
                  Terms & Conditions
                </a>
              </li>
            </ul>
          </div>
        </div>

        <div className="border-t border-gray-200 pt-6 sm:pt-8">
          <div className="flex flex-col lg:flex-row items-center justify-between gap-4">
            <p className="text-xs sm:text-sm text-gray-600 text-center lg:text-left">
              © 2025 Healthsta Pharmacy. All rights reserved. | Licensed Pharmacy Chain
            </p>
            <div className="flex flex-wrap items-center justify-center gap-4 sm:gap-6 lg:gap-8">
              <div className="flex items-center space-x-1.5 sm:space-x-2 text-xs sm:text-sm text-gray-600">
                <CheckCircle className="w-4 h-4 sm:w-5 sm:h-5 text-green-600 flex-shrink-0" />
                <span>Verified Medicines</span>
              </div>
              <div className="flex items-center space-x-1.5 sm:space-x-2 text-xs sm:text-sm text-gray-600">
                <CheckCircle className="w-4 h-4 sm:w-5 sm:h-5 text-green-600 flex-shrink-0" />
                <span>Licensed Pharmacy</span>
              </div>
              <div className="flex items-center space-x-1.5 sm:space-x-2 text-xs sm:text-sm text-gray-600">
                <CheckCircle className="w-4 h-4 sm:w-5 sm:h-5 text-green-600 flex-shrink-0" />
                <span>Secure Payments</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
}
