export default function AppDownload() {
  return (
    <section className="py-8 sm:py-12 lg:py-16 bg-gradient-to-r from-cyan-100 to-blue-100">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex flex-col lg:flex-row items-center justify-between gap-8 lg:gap-12">
          <div className="hidden lg:block w-48 xl:w-64 flex-shrink-0">
            <div className="bg-white rounded-2xl lg:rounded-3xl shadow-xl p-3 lg:p-4 transform -rotate-6">
              <div className="bg-gradient-to-b from-blue-500 to-blue-600 rounded-xl lg:rounded-2xl p-4 lg:p-6 text-white">
                <div className="flex items-center space-x-2 mb-4 lg:mb-6">
                  <div className="w-6 h-6 lg:w-8 lg:h-8 bg-white rounded-full flex items-center justify-center">
                    <span className="text-blue-600 font-bold text-sm lg:text-base">H</span>
                  </div>
                  <span className="font-semibold text-sm lg:text-base">Healthsta</span>
                </div>
                <div className="space-y-3 lg:space-y-4">
                  <div className="bg-white/20 rounded-lg p-2 lg:p-3 backdrop-blur">
                    <div className="text-xs lg:text-sm opacity-90">Search medicines</div>
                  </div>
                  <div className="flex items-center space-x-3 lg:space-x-4">
                    <div className="w-12 h-12 lg:w-16 lg:h-16 bg-white rounded-lg lg:rounded-xl flex items-center justify-center">
                      <svg viewBox="0 0 40 40" className="w-8 h-8 lg:w-10 lg:h-10">
                        <rect x="10" y="15" width="20" height="15" fill="#3b82f6" rx="2"/>
                      </svg>
                    </div>
                    <div className="w-12 h-12 lg:w-16 lg:h-16 bg-white rounded-lg lg:rounded-xl flex items-center justify-center">
                      <svg viewBox="0 0 40 40" className="w-8 h-8 lg:w-10 lg:h-10">
                        <circle cx="20" cy="20" r="8" fill="#10b981"/>
                      </svg>
                    </div>
                  </div>
                  <div className="bg-green-400 rounded-lg p-3 lg:p-4">
                    <div className="text-sm lg:text-lg font-bold">24/7 LAB 400 OFF</div>
                    <div className="text-xs lg:text-sm">on orders above ₹999</div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div className="flex-1 text-center px-4 sm:px-8 lg:px-12">
            <h2 className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 mb-2 sm:mb-4">Simplifying</h2>
            <h2 className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 mb-2 sm:mb-4">Healthcare</h2>
            <h2 className="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 mb-4 sm:mb-6 lg:mb-8">Impacting Lives</h2>
            <p className="text-base sm:text-lg lg:text-xl text-gray-700 mb-6 sm:mb-8">Download the App for Free</p>

            <div className="flex flex-col sm:flex-row items-center justify-center gap-3 sm:gap-4">
              <a
                href="#"
                className="flex items-center space-x-2 sm:space-x-3 bg-black text-white px-4 sm:px-6 py-2.5 sm:py-3 rounded-lg hover:bg-gray-800 w-full sm:w-auto justify-center"
              >
                <svg className="w-6 h-6 sm:w-8 sm:h-8 flex-shrink-0" viewBox="0 0 24 24" fill="currentColor">
                  <path d="M3,20.5V3.5C3,2.91 3.34,2.39 3.84,2.15L13.69,12L3.84,21.85C3.34,21.6 3,21.09 3,20.5M16.81,15.12L6.05,21.34L14.54,12.85L16.81,15.12M20.16,10.81C20.5,11.08 20.75,11.5 20.75,12C20.75,12.5 20.53,12.9 20.18,13.18L17.89,14.5L15.39,12L17.89,9.5L20.16,10.81M6.05,2.66L16.81,8.88L14.54,11.15L6.05,2.66Z" />
                </svg>
                <div className="text-left">
                  <div className="text-xs">GET IT ON</div>
                  <div className="font-semibold text-sm sm:text-base">Google Play</div>
                </div>
              </a>

              <a
                href="#"
                className="flex items-center space-x-2 sm:space-x-3 bg-black text-white px-4 sm:px-6 py-2.5 sm:py-3 rounded-lg hover:bg-gray-800 w-full sm:w-auto justify-center"
              >
                <svg className="w-6 h-6 sm:w-8 sm:h-8 flex-shrink-0" viewBox="0 0 24 24" fill="currentColor">
                  <path d="M18.71,19.5C17.88,20.74 17,21.95 15.66,21.97C14.32,22 13.89,21.18 12.37,21.18C10.84,21.18 10.37,21.95 9.1,22C7.79,22.05 6.8,20.68 5.96,19.47C4.25,17 2.94,12.45 4.7,9.39C5.57,7.87 7.13,6.91 8.82,6.88C10.1,6.86 11.32,7.75 12.11,7.75C12.89,7.75 14.37,6.68 15.92,6.84C16.57,6.87 18.39,7.1 19.56,8.82C19.47,8.88 17.39,10.1 17.41,12.63C17.44,15.65 20.06,16.66 20.09,16.67C20.06,16.74 19.67,18.11 18.71,19.5M13,3.5C13.73,2.67 14.94,2.04 15.94,2C16.07,3.17 15.6,4.35 14.9,5.19C14.21,6.04 13.07,6.7 11.95,6.61C11.8,5.46 12.36,4.26 13,3.5Z" />
                </svg>
                <div className="text-left">
                  <div className="text-xs">Download on the</div>
                  <div className="font-semibold text-sm sm:text-base">App Store</div>
                </div>
              </a>
            </div>
          </div>

          <div className="hidden lg:block w-48 xl:w-64 flex-shrink-0">
            <div className="bg-white rounded-2xl lg:rounded-3xl shadow-xl p-3 lg:p-4 transform rotate-6">
              <div className="bg-gradient-to-b from-blue-400 to-cyan-400 rounded-xl lg:rounded-2xl p-4 lg:p-6 text-white">
                <div className="flex items-center justify-between mb-4 lg:mb-6">
                  <span className="font-semibold text-sm lg:text-base">My Orders</span>
                  <div className="w-6 h-6 lg:w-8 lg:h-8 bg-white/30 rounded-full"></div>
                </div>
                <div className="space-y-2 lg:space-y-3">
                  <div className="bg-white rounded-lg lg:rounded-xl p-3 lg:p-4">
                    <div className="flex items-center justify-between">
                      <div className="w-10 h-10 lg:w-12 lg:h-12 bg-orange-100 rounded-lg"></div>
                      <div className="text-blue-600 font-bold text-sm lg:text-base">₹299</div>
                    </div>
                  </div>
                  <div className="bg-white rounded-lg lg:rounded-xl p-3 lg:p-4">
                    <div className="flex items-center justify-between">
                      <div className="w-10 h-10 lg:w-12 lg:h-12 bg-blue-100 rounded-lg"></div>
                      <div className="text-blue-600 font-bold text-sm lg:text-base">₹599</div>
                    </div>
                  </div>
                  <div className="bg-purple-500 rounded-lg lg:rounded-xl p-3 lg:p-4">
                    <div className="flex items-center space-x-2">
                      <svg className="w-6 h-6 lg:w-8 lg:h-8" viewBox="0 0 24 24" fill="white">
                        <path d="M9,11.75A1.25,1.25 0 0,0 7.75,13A1.25,1.25 0 0,0 9,14.25A1.25,1.25 0 0,0 10.25,13A1.25,1.25 0 0,0 9,11.75M15,11.75A1.25,1.25 0 0,0 13.75,13A1.25,1.25 0 0,0 15,14.25A1.25,1.25 0 0,0 16.25,13A1.25,1.25 0 0,0 15,11.75M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z" />
                      </svg>
                      <span className="text-xs lg:text-sm">Get health tips</span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
