const fs = require('fs').promises;
const path = require('path');

const deleteFile = async (filePath) => {
  try {
    await fs.unlink(filePath);
    console.log(`Successfully deleted file: ${filePath}`);
    return true;
  } catch (error) {
    if (error.code === 'ENOENT') {
      console.log(`File not found: ${filePath}`);
    } else {
      console.error(`Error deleting file ${filePath}:`, error);
    }
    return false;
  }
};

const deleteFiles = async (filePaths) => {
  if (!Array.isArray(filePaths)) {
    filePaths = [filePaths];
  }
  
  const results = await Promise.all(
    filePaths.map(filePath => deleteFile(filePath))
  );
  return results.every(Boolean);
};

const getUploadsPath = (subfolder = '') => {
  return path.join(__dirname, '..', 'uploads', subfolder);
};

module.exports = {
  deleteFile,
  deleteFiles,
  getUploadsPath
};
