const express = require('express');
const router = express.Router();
const { catchAsync } = require('../middleware/errorHandler');
const { auth, authorize } = require('../middleware/auth');
const userController = require('../controllers/userController');

// Apply auth middleware to all routes
router.use(auth);

// @route   GET /api/users
// @desc    Get all users (admin only)
// @access  Private/Admin
router.get('/', authorize('admin'), catchAsync(userController.getAllUsers));

// @route   GET /api/users/:id
// @desc    Get single user by ID
// @access  Private/Admin or same user
router.get('/:id', catchAsync(userController.getUser));

// @route   PUT /api/users/:id
// @desc    Update user
// @access  Private/Admin or same user
router.put('/:id', catchAsync(userController.updateUser));

// @route   DELETE /api/users/:id
// @desc    Delete user
// @access  Private/Admin or same user
router.delete('/:id', catchAsync(userController.deleteUser));

module.exports = router;
