const express = require('express');
const router = express.Router();
const { auth, authorize } = require('../middleware/auth');
const uploadController = require('../controllers/uploadController');
const { upload } = require('../config/multer');

// Apply auth middleware to all routes
router.use(auth);

// @route   POST /api/upload
// @desc    Upload a file
// @access  Private
router.post('/', 
  authorize('admin', 'store'),
  upload.single('file'),
  uploadController.uploadFile
);

// @route   DELETE /api/upload/:filename
// @desc    Delete a file
// @access  Private/Admin
router.delete('/:filename', 
  authorize('admin'),
  uploadController.deleteFile
);

module.exports = router;
