const express = require('express');
const router = express.Router();
const {
  getAllUnits,
  getUnitById,
  createUnit,
  updateUnit,
  toggleUnitStatus,
  deleteUnit,
  getUnitStatistics,
  searchUnits
} = require('../controllers/unitsController');

// Get all units
router.get('/', getAllUnits);

// Search units
router.get('/search', searchUnits);

// Get unit statistics
router.get('/analytics/statistics', getUnitStatistics);

// Get unit by ID
router.get('/:id', getUnitById);

// Create new unit
router.post('/', createUnit);

// Update unit
router.put('/:id', updateUnit);

// Toggle unit status
router.patch('/:id/toggle-status', toggleUnitStatus);

// Delete unit (hard delete)
router.delete('/:id', deleteUnit);

module.exports = router; 