const express = require('express');
const {
  getSettings,
  updateSettings,
} = require('../controllers/settingsController');

const router = express.Router();

const { auth, authorize } = require('../middleware/auth');

router
  .route('/')
  .get(auth, authorize('admin'), getSettings)
  .post(auth, authorize('admin'), updateSettings);

module.exports = router;
