const express = require('express');
const {
  getAllRefunds,
  getRefundById,
  createRefund,
  updateRefund,
  deleteRefund,
} = require('../controllers/refundsController');

const Refund = require('../models/Refund');
const advancedResults = require('../middleware/advancedResults');
const { auth, authorize } = require('../middleware/auth');

const router = express.Router();

router.use(auth);
router.use(authorize('admin', 'superadmin'));

router
  .route('/')
  .get(advancedResults(Refund, [{ path: 'order', select: 'orderNumber' }, { path: 'customer', select: 'name' }]), getAllRefunds)
  .post(createRefund);

router
  .route('/:id')
  .get(getRefundById)
  .put(updateRefund)
  .delete(deleteRefund);

module.exports = router;
