const express = require('express');
const router = express.Router();
const itemOrderController = require('../controllers/itemOrderController');

// Get item order by category
router.get('/:category_id', itemOrderController.getItemOrder);

// Update item order
router.put('/:category_id', itemOrderController.updateItemOrder);

// Reset item order
router.delete('/:category_id', itemOrderController.resetItemOrder);

module.exports = router;
