const express = require('express');
const router = express.Router();
const { 
  createHomepageSection, 
  getHomepageSections, 
  getHomepageSectionById,
  updateHomepageSection, 
  deleteHomepageSection,
  reorderHomepageSections,
  getDisplayHomepageSections
} = require('../controllers/homepageSectionsController');
const { auth, authorize } = require('../middleware/auth');
const { catchAsync } = require('../middleware/errorHandler');

// Public route to get display sections
router.get('/display', catchAsync(getDisplayHomepageSections));

// Admin routes (require authentication and admin role)
router.route('/')
  .get(auth, authorize('admin'), catchAsync(getHomepageSections))
  .post(auth, authorize('admin'), catchAsync(createHomepageSection));

// Reorder sections route - must come before /:id to avoid conflict
router.put('/reorder', auth, authorize('admin'), catchAsync(reorderHomepageSections));

// Routes with ID parameter
router.route('/:id')
  .get(auth, authorize('admin'), catchAsync(getHomepageSectionById))
  .put(auth, authorize('admin'), catchAsync(updateHomepageSection))
  .delete(auth, authorize('admin'), catchAsync(deleteHomepageSection));

module.exports = router;



