const express = require('express');
const router = express.Router();
const {
  getFundsTransfers,
  getFundsTransfer,
  createFundsTransfer,
  updateFundsTransfer,
  deleteFundsTransfer,
} = require('../controllers/fundsTransferController');

const { auth, authorize } = require('../middleware/auth');

// All routes are protected and only accessible by admin
router.use(auth);
router.use(authorize('admin'));

router
  .route('/')
  .get(getFundsTransfers)
  .post(createFundsTransfer);

router
  .route('/:id')
  .get(getFundsTransfer)
  .put(updateFundsTransfer)
  .delete(deleteFundsTransfer);

module.exports = router;
