const express = require('express');
const router = express.Router();
const { auth, authorize } = require('../middleware/auth');
const {
  getDiscounts,
  getDiscount,
  createDiscount,
  updateDiscount,
  deleteDiscount,
  applyDiscount,
  getDiscountStats,
  getActiveDiscounts
} = require('../controllers/discountsController');

// Public routes
router.get('/', getDiscounts);
router.get('/active', getActiveDiscounts);
router.get('/stats', getDiscountStats);
router.get('/:id', getDiscount);

// Protected routes (require authentication)
router.use(auth);

// Apply discount code (authenticated users)
router.post('/apply', applyDiscount);

// Admin only routes
router.use(authorize('admin'));

router.post('/', createDiscount);
router.put('/:id', updateDiscount);
router.delete('/:id', deleteDiscount);

module.exports = router;