const express = require('express');
const router = express.Router();
const {
  getCashCollections,
  getCashCollection,
  createCashCollection,
  updateCashCollection,
  deleteCashCollection,
} = require('../controllers/cashCollectionController');

const { auth, authorize } = require('../middleware/auth');

// All routes are protected and only accessible by admin
router.use(auth);
router.use(authorize('admin'));

router
  .route('/')
  .get(getCashCollections)
  .post(createCashCollection);

router
  .route('/:id')
  .get(getCashCollection)
  .put(updateCashCollection)
  .delete(deleteCashCollection);

module.exports = router;
