const express = require('express');
const router = express.Router();
const { auth } = require('../middleware/auth');
const cartController = require('../controllers/cartController');

/**
 * @route   GET /api/cart/check-prescription
 * @desc    Check if cart contains prescription items
 * @access  Private
 */
router.get('/check-prescription', auth, cartController.checkPrescriptionRequired);

/**
 * @route   PUT /api/cart/:id/prescription
 * @desc    Update cart with prescription info
 * @access  Private
 */
router.put('/:id/prescription', auth, cartController.updateCartWithPrescription);

module.exports = router;
