const express = require('express');
const router = express.Router();
const {
  getAllBrands,
  getBrandById,
  getBrandsWithItemCounts,
  searchBrands,
  getBrandsByCompany,
  createBrand,
  updateBrand,
  toggleBrandStatus,
  deleteBrand,
  getBrandStatistics,
  getBrandsNeedingAttention
} = require('../controllers/brandsController');
const { uploadBrandImage, handleUploadError } = require('../middleware/upload');

// Basic CRUD Routes
// Get all brands with pagination and search
router.get('/', getAllBrands);

// Get brand by ID with details
router.get('/:id', getBrandById);

// Create new brand
router.post('/', uploadBrandImage, handleUploadError, createBrand);

// Update brand
router.put('/:id', uploadBrandImage, handleUploadError, updateBrand);

// Toggle brand status
router.patch('/:id/toggle-status', toggleBrandStatus);

// Delete brand (soft delete)
router.delete('/:id', deleteBrand);

// Advanced Search and Analytics Routes
// Search brands
router.get('/search', searchBrands);

// Get brands by company name
router.get('/company/:companyName', getBrandsByCompany);

// Analytics Routes
// Get brands with item counts for analytics
router.get('/analytics/item-counts', getBrandsWithItemCounts);

// Get brand statistics for dashboard
router.get('/statistics', getBrandStatistics);

// Get brands needing attention (low inventory)
router.get('/needing-attention', getBrandsNeedingAttention);

module.exports = router; 