const express = require('express');
const router = express.Router();
const {
  getBonuses,
  getBonus,
  createBonus,
  updateBonus,
  deleteBonus
} = require('../controllers/bonusesController');

// Import auth middleware
const { auth, authorize } = require('../middleware/auth');

// Define routes with protection and authorization
router.route('/')
  .get(getBonuses)
  .post(createBonus);

router.route('/:id')
  .get(getBonus)
  .put(updateBonus)
  .delete(deleteBonus);

module.exports = router;