const mongoose = require('mongoose');

const cashCollectionSchema = new mongoose.Schema(
  {
    deliveryBoy: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'User',
      required: true,
    },
    orderId: {
      type: String,
      required: true,
    },
    amount: {
      type: Number,
      required: true,
      min: 0,
    },
    collectionDate: {
      type: Date,
      default: Date.now,
    },
    handoverDate: {
      type: Date,
    },
    status: {
      type: String,
      enum: ['pending', 'collected', 'handed_over'],
      default: 'pending',
    },
    notes: String,
    collectedBy: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'User',
      required: true,
    },
  },
  {
    timestamps: true,
    toJSON: { virtuals: true },
    toObject: { virtuals: true },
  }
);

// Indexes for better query performance
cashCollectionSchema.index({ deliveryBoy: 1, status: 1 });
cashCollectionSchema.index({ orderId: 1 });

const CashCollection = mongoose.model('CashCollection', cashCollectionSchema);

module.exports = CashCollection;
