const mongoose = require('mongoose');

const SettingsSchema = new mongoose.Schema({
  siteName: {
    type: String,
    default: 'Healthstra',
  },
  contactEmail: {
    type: String,
    match: [/\S+@\S+\.\S+/, 'Please use a valid email address.'],
  },
  itemsPerPage: {
    type: Number,
    default: 10,
  },
  currency: {
    type: String,
    default: 'USD',
  },
  outOfStockThreshold: {
    type: Number,
    default: 5,
    min: 0,
    max: 1000,
  },
  inStockThreshold: {
    type: Number,
    default: 10,
    min: 0,
    max: 1000,
  },
}, { timestamps: true });

module.exports = mongoose.model('Settings', SettingsSchema);
