const mongoose = require('mongoose');

const bonusSchema = new mongoose.Schema({
  name: {
    type: String,
    required: [true, 'Bonus name is required'],
    trim: true,
    maxlength: [100, 'Bonus name cannot exceed 100 characters']
  },
  description: {
    type: String,
    trim: true
  },
  bonusType: {
    type: String,
    required: true,
    enum: ['fixed', 'percentage']
  },
  value: {
    type: Number,
    required: true,
    min: [0, 'Bonus value cannot be negative']
  },
  startDate: {
    type: Date,
    required: true
  },
  endDate: {
    type: Date,
    validate: {
      validator: function(v) {
        return !v || v > this.startDate;
      },
      message: 'End date must be after start date'
    }
  },
  isActive: {
    type: Boolean,
    default: true
  }
}, {
  timestamps: true
});

const Bonus = mongoose.model('Bonus', bonusSchema);

module.exports = Bonus;