const Bonus = require('../models/Bonus');

// @desc    Get all bonuses
// @route   GET /api/bonuses
// @access  Private/Admin
exports.getBonuses = async (req, res) => {
  try {
    const bonuses = await Bonus.find();
    res.status(200).json({ success: true, data: bonuses });
  } catch (error) {
    res.status(500).json({ success: false, message: 'Server Error' });
  }
};

// @desc    Get single bonus
// @route   GET /api/bonuses/:id
// @access  Private/Admin
exports.getBonus = async (req, res) => {
  try {
    const bonus = await Bonus.findById(req.params.id);
    if (!bonus) {
      return res.status(404).json({ success: false, message: 'Bonus not found' });
    }
    res.status(200).json({ success: true, data: bonus });
  } catch (error) {
    res.status(500).json({ success: false, message: 'Server Error' });
  }
};

// @desc    Create bonus
// @route   POST /api/bonuses
// @access  Private/Admin
exports.createBonus = async (req, res) => {
  try {
    const bonus = await Bonus.create(req.body);
    res.status(201).json({ success: true, data: bonus });
  } catch (error) {
    res.status(400).json({ success: false, message: error.message });
  }
};

// @desc    Update bonus
// @route   PUT /api/bonuses/:id
// @access  Private/Admin
exports.updateBonus = async (req, res) => {
  try {
    const bonus = await Bonus.findByIdAndUpdate(req.params.id, req.body, {
      new: true,
      runValidators: true
    });
    if (!bonus) {
      return res.status(404).json({ success: false, message: 'Bonus not found' });
    }
    res.status(200).json({ success: true, data: bonus });
  } catch (error) {
    res.status(400).json({ success: false, message: error.message });
  }
};

// @desc    Delete bonus
// @route   DELETE /api/bonuses/:id
// @access  Private/Admin
exports.deleteBonus = async (req, res) => {
  try {
    const bonus = await Bonus.findByIdAndDelete(req.params.id);
    if (!bonus) {
      return res.status(404).json({ success: false, message: 'Bonus not found' });
    }
    res.status(200).json({ success: true, data: {} });
  } catch (error) {
    res.status(500).json({ success: false, message: 'Server Error' });
  }
};