require('dotenv').config();

const config = {
  // Server configuration
  port: process.env.PORT || 5000,
  nodeEnv: process.env.NODE_ENV || 'development',
  
  // Database configuration
  db: {
    uri: process.env.MONGODB_URI || 'mongodb://localhost:27017/helthstra',
    options: {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    },
  },
  
  // JWT configuration
  jwt: {
    secret: process.env.JWT_SECRET || 'your_jwt_secret_key',
    expiresIn: process.env.JWT_EXPIRES_IN || '30d',
  },
  
  // Google Maps/Geocoding API
  googleMaps: {
    apiKey: process.env.GOOGLE_MAPS_API_KEY || 'your_google_maps_api_key',
    geocodeUrl: 'https://maps.googleapis.com/maps/api/geocode/json',
  },
  
  // File upload configuration
  uploads: {
    directory: process.env.UPLOAD_DIR || 'uploads',
    maxFileSize: 5 * 1024 * 1024, // 5MB
    allowedFileTypes: ['image/jpeg', 'image/png', 'image/gif'],
  },
  
  // CORS configuration
  cors: {
    origin: process.env.CORS_ORIGIN || '*',
    methods: ['GET', 'POST', 'PUT', 'PATCH', 'DELETE', 'OPTIONS'],
    allowedHeaders: ['Content-Type', 'Authorization'],
  },
};

// Helper function to get configuration values
const getConfig = (key) => {
  const keys = key.split('.');
  return keys.reduce((obj, k) => (obj && obj[k] !== undefined ? obj[k] : undefined), config);
};

// Export the configuration and helper functions
module.exports = {
  ...config,
  get: getConfig,
  getGeocodingApiKey: () => getConfig('googleMaps.apiKey'),
};
