# Hittok Backend API

This is the backend API for the Hittok application, built with Node.js, Express, and MySQL.

## Features

- **User Authentication**: JWT-based authentication with email verification and password reset
- **Role-Based Access Control**: Different roles (admin, delivery_boy, user) with appropriate permissions
- **Product Management**: CRUD operations for products, categories, brands, etc.
- **Order Management**: Complete order processing workflow
- **Prescription Upload**: For medical/pharmacy orders
- **Delivery Management**: Assign and track deliveries
- **Payment Integration**: Support for multiple payment methods
- **File Uploads**: For product images and prescription documents
- **Real-time Updates**: Using Socket.io for order status updates
- **API Documentation**: Using Swagger/OpenAPI
- **Security**: Rate limiting, data sanitization, CORS, and more

## Prerequisites

- Node.js (v14 or higher)
- MySQL (v5.7 or higher)
- npm or yarn

## Installation

1. Clone the repository:
   ```bash
   git clone https://github.com/yourusername/hittok-backend.git
   cd hittok-backend
   ```

2. Install dependencies:
   ```bash
   npm install
   # or
   yarn
   ```

3. Create a `.env` file in the root directory and copy the contents from `.env.example`:
   ```bash
   cp .env.example .env
   ```

4. Update the `.env` file with your database credentials and other settings.

5. Import the database schema:
   - Create a new MySQL database
   - Import the `database.sql` file (you'll need to create this from your database)

6. Start the development server:
   ```bash
   # Development
   npm run dev
   
   # Production
   npm start
   ```

   The API will be available at `http://localhost:5000/api/v1`

## API Documentation

API documentation is available at `/api-docs` when running in development mode.

## Available Scripts

- `npm run dev`: Start the development server with nodemon
- `npm start`: Start the production server
- `npm test`: Run tests
- `npm run lint`: Lint the codebase
- `npm run format`: Format the code using Prettier
- `npm run docs:generate`: Generate API documentation

## Project Structure

```
backend/
├── config/           # Configuration files
├── controllers/      # Route controllers
├── middleware/       # Custom middleware
├── models/           # Database models
├── routes/           # API routes
├── utils/            # Utility functions
├── validators/       # Request validation schemas
├── .env.example      # Environment variables example
├── .eslintrc.js      # ESLint configuration
├── .prettierrc       # Prettier configuration
├── app.js            # Express app configuration
├── package.json      # Project dependencies
└── server.js         # Server entry point
```

## Environment Variables

See `.env.example` for a list of required environment variables.

## Database Schema

The database schema is defined in the `database.sql` file.

## Authentication

This API uses JWT for authentication. Include the JWT token in the `Authorization` header for protected routes:

```
Authorization: Bearer <token>
```

## Error Handling

All error responses follow the same format:

```json
{
  "success": false,
  "error": "Error message"
}
```

## Rate Limiting

API requests are limited to 100 requests per hour per IP address by default.

## Contributing

1. Fork the repository
2. Create a new branch (`git checkout -b feature/AmazingFeature`)
3. Commit your changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Contact

Your Name - your.email@example.com

Project Link: [https://github.com/yourusername/hittok-backend](https://github.com/yourusername/hittok-backend)
